/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class NBTIngredient
extends Ingredient {
    private final ItemStack stack;

    protected NBTIngredient(ItemStack stack) {
        super(Stream.of(new Ingredient.SingleItemList(stack)));
        this.stack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.stack.func_77973_b() == input.func_77973_b() && this.stack.func_77952_i() == input.func_77952_i() && this.stack.areShareTagsEqual(input);
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public JsonElement func_200304_c() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID(Serializer.INSTANCE).toString());
        json.addProperty("item", this.stack.func_77973_b().getRegistryName().toString());
        json.addProperty("count", (Number)this.stack.func_190916_E());
        if (this.stack.func_77942_o()) {
            json.addProperty("nbt", this.stack.func_77978_p().toString());
        }
        return json;
    }

    public static class Serializer
    implements IIngredientSerializer<NBTIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public NBTIngredient parse(PacketBuffer buffer) {
            return new NBTIngredient(buffer.func_150791_c());
        }

        @Override
        public NBTIngredient parse(JsonObject json) {
            return new NBTIngredient(CraftingHelper.getItemStack(json, true));
        }

        @Override
        public void write(PacketBuffer buffer, NBTIngredient ingredient) {
            buffer.func_150788_a(ingredient.stack);
        }
    }
}

